"""

       Universite catholique de Louvain
       CEREM : Centre for research in mechatronics
       http://www.robotran.be
       Contact : info@robotran.be


       Main script template for complete model:
       -----------------------------------------------
        This template loads the data file *.mbs and execute:
          - the coordinate partitioning module
          - the direct dynamic module (time integration of
            equations of motion).
          - the equilibrium module
          - the modal module

        (c) Universite catholique de Louvain

        Project : a pendulum spring
        Author: Sebastien Timmermans
        Date: January 2020

"""


#==============================================================================
# Packages loading
#==============================================================================
import sys
sys.path.insert(1,"./../../../../mbsysc/MBsysC/build/python") # Relative path for this example script

import MBsysPy as Robotran


#==============================================================================
# Project loading
#==============================================================================
mbs_data = Robotran.MbsData("../dataR/pendulum_spring_python.mbs")

#==============================================================================
# Partitionning
#==============================================================================
mbs_data.process = 1
mbs_part = Robotran.MbsPart(mbs_data)
mbs_part.set_options(rowperm = 1, verbose = 1)
mbs_part.run()

#==============================================================================
# Equilibrium
#==============================================================================
mbs_data.process = 2
mbs_equil = Robotran.MbsEquil(mbs_data)
mbs_equil.set_options(method = 1, senstol = 1e-6, verbose = 1)
mbs_equil.run()

#==============================================================================
# Modal Analysis
#==============================================================================
mbs_data.process = 4
mbs_modal = Robotran.MbsModal(mbs_data)
mbs_modal.set_options(save_result = 1, save_anim = 1, mode_ampl = 0.2)
mbs_modal.run()

#==============================================================================
# Direct Dynamics
#==============================================================================
mbs_data.reset()
mbs_data.process = 3
print(mbs_data)
mbs_dirdyn = Robotran.MbsDirdyn(mbs_data)
mbs_dirdyn.set_options(dt0 = 1e-3, tf = 5.0, save2file = 1)
mbs_dirdyn.run()

##==============================================================================
## Plotting
##==============================================================================
import numpy as np
from matplotlib import pyplot as plt

plt.figure()
q = np.loadtxt("../resultsR/dirdyn_q.res")
plt.figure(mbs_data.mbs_name)
plt.plot(q[:,0], q[:,1])
plt.xlabel("time [s]")
plt.ylabel("q1 [rad]")
plt.xlim((0,5))
plt.show()
